//  Amplitude Modulator SourceCode.
//  It shows how to demultiplex two multiplexed signals
//  and then perform an Amplitude Modulation.
//  Any part of this code can be used freely.
//  If any good programmer finds any big mistake in
//  this code please tell it to me.  I'd like
//  to fix it.

//  The interesting part is only the mi::work() function.

//   Ynzn

#include <malloc.h>
#include "MachineInterface.h"
#include "..\dsplib\dsplib.h"

CMachineParameter const paraModCutOff =
{
	pt_word,
	"ModCutOff",
	"Modulator Filter CutOff",
	100,
	11025,
	0,
	MPF_STATE,
	11025
};

CMachineParameter const paraCarCutOff =
{
	pt_word,
	"CarCutOff",
	"Carrier Filter CutOff",
	11025,
	21950,
	0,
	MPF_STATE,
	11025
};

CMachineParameter const paraAbsFloor =
{
	pt_word,
	"AbsFloor",
	"Floor (Absolute)",
	0,
	32758,
	65000,
	MPF_STATE,
	0
};

CMachineParameter const *pParameters[] =
{
	&paraModCutOff,
	&paraCarCutOff,
	&paraAbsFloor,	
};

#pragma pack(1)

class gvals
{
public:
	word modcutoff;
	word carcutoff;
	word floor;	
};

#pragma pack()

CMachineInfo const MacInfo =
{
	MT_EFFECT,  // type
	MI_VERSION, // version
	0, // flags
	0, // mintracks
	0, // mxtracks
	3, // globalparams
	0, // trackparams
	pParameters,  // paramlist
	0,  // attributes
	NULL, // attribute list
	"DeMux + Amplitude Modulation",  // name of the machine
	"DeMux+AM",  // short name
	"Ynzn", // I am the creator
	NULL  // cmdlist		  
};

//  I always get lost with CMachineInfo members.  I have to
//  put those comments.  Sorry.

class mi:public CMachineInterface
{
public:
	mi();
	virtual ~mi();

	virtual void Init(CMachineDataInput *const pi);
	virtual void Tick();
	virtual bool Work(float *psamples, int numsamples, int const mode);
	
private:
	gvals gval;
	gvals tval;
	CBWState ModFilt;
	CBWState CarFilt;
};

DLL_EXPORTS

mi::mi()
{
	GlobalVals = &gval;
	AttrVals = NULL;
	TrackVals = NULL;	   
}

mi::~mi()
{	
}

void mi::Init(CMachineDataInput * const pi)
{
	DSP_BW_Reset(ModFilt);
	DSP_BW_Reset(CarFilt);
}

void mi::Tick()
{
	if (gval.modcutoff != paraModCutOff.NoValue)
	{
		tval.modcutoff=gval.modcutoff;
		DSP_BW_InitLowpass(ModFilt, tval.modcutoff);
	}
		
	if (gval.carcutoff != paraCarCutOff.NoValue)
	{
		tval.carcutoff=gval.carcutoff;
		DSP_BW_InitHighpass(CarFilt, tval.carcutoff);
	}

	if (gval.floor != paraAbsFloor.NoValue)
		tval.floor=gval.floor;	
}

bool mi::Work(float *psamples, int numsamples, int const mode)
{	
	float *modulator;  // buffer for the modulator
	float *carrier;    // buffer for the carrier

	float *cindex;     // index for the carrier		
	float *mindex;     // index for the modulator
	int ns;			   // numsamples
	int i;			   // used to demux
	

	if (mode == WM_WRITE || mode == WM_NOIO)
		return false;
	if (mode == WM_READ)
		return true;	

	// first: create buffers

	carrier = (float *)malloc(numsamples * sizeof(float));
	if (carrier == NULL) return false;
	
	modulator = (float *)malloc(numsamples * sizeof(float));
	if (modulator == NULL)
	{
		free(carrier);
		return false;
	}
	

	// second:	obtain copies of psamples for the modulator and
	//			the carrier.  Then filter them.

	DSP_Copy(carrier, psamples,numsamples);
	DSP_Copy(modulator, psamples,numsamples);	
	DSP_BW_Work(ModFilt, modulator, numsamples, mode);	
	DSP_BW_Work(CarFilt,   carrier, numsamples, mode);


	// third: Invert carrier's spectrum.

	cindex=carrier;
	ns = numsamples;
	i = 1;
	do {
		*cindex*=i;
		i*=-1;
		cindex++;
		ns--;
	} while (ns);
	
	
	// fourth:  modulate
	
	cindex=carrier;
	mindex=modulator;
		do {
			*psamples=(float)(*mindex * (*cindex + (tval.floor/100)));
			psamples++;
			cindex++;
			mindex++;
			numsamples--;
		} while(numsamples);
	

    // fifth: free mem

	free(carrier);
	free(modulator);
	return true;
}

// That's all folks!
// Ynzn
// cjan5813@alu-etsetb.upc.es