//  Amplitude Modulator SourceCode.
//  It shows how to demultiplex two multiplexed signals
//  and then perform an Amplitude Modulation.
//  Any part of this code can be used freely.
//  If any good programmer finds any big mistake in
//  this code please tell it to me.  I'd like
//  to fix it.

//  The interesting part is only the mi::work() function.

//   Ynzn
#include "malloc.h"
#include "MachineInterface.h"
#include "..\dsplib\dsplib.h"

CMachineParameter const paraModCutOff =
{
	pt_word,
	"ModCutOff",
	"Modulator Filter CutOff",
	100,
	11025,
	0,
	MPF_STATE,
	11025
};

CMachineParameter const paraResonance =
{
	pt_byte,
	"Resonance",
	"Filter Resonance",
	0,
	128,
	255,
	MPF_STATE,
	64
};

CMachineParameter const *pParameters[] =
{
	&paraModCutOff,
	&paraResonance,
};

#pragma pack(1)

class gvals
{
public:
	word modcutoff;
	byte resonance;
};

#pragma pack()

CMachineInfo const MacInfo =
{
	MT_EFFECT,  // type
	MI_VERSION, // version
	0, // flags
	0, // mintracks
	0, // mxtracks
	2, // globalparams
	0, // trackparams
	pParameters,  // paramlist
	0,  // attributes
	NULL, // attribute list
	"DeMux + Amplitude Modulation",  // name of the machine
	"DeMux+AM",  // short name
	"Ynzn", // I am the creator
	NULL  // cmdlist		  
};

//  I always get lost with CMachineInfo members.  I have to
//  put those comments.  Sorry.

class mi:public CMachineInterface
{
public:
	mi();
	virtual ~mi();

	virtual void Init(CMachineDataInput *const pi);
	virtual void Tick();
	virtual bool Work(float *psamples, int numsamples, int const mode);
	
private:
	gvals gval;
	CBWState ModFilt;
	CBWState ModRes;
	float Modcutoff;
	float Resonance;
};

DLL_EXPORTS

mi::mi()
{
	GlobalVals = &gval;
	AttrVals = NULL;
	TrackVals = NULL;	   
}

mi::~mi()
{	
}

void mi::Init(CMachineDataInput * const pi)
{
	DSP_BW_Reset(ModFilt);
	Modcutoff=11025;
	Resonance=64;
}

void mi::Tick()
{
	if (gval.modcutoff != paraModCutOff.NoValue)
	{
		Modcutoff=gval.modcutoff;
		DSP_BW_InitLowpass(ModFilt, Modcutoff);
	}
	
	if (gval.resonance != paraResonance.NoValue)
	{
		Resonance=gval.resonance;
		DSP_BW_InitBandpass(ModRes, Modcutoff,4);
	}	
}

bool mi::Work(float *psamples, int numsamples, int const mode)
{	
	if (mode==WM_READWRITE)
	{
	float *aux=(float *)malloc(numsamples);

	DSP_Copy(psamples,aux,numsamples);
	DSP_BW_Work(ModFilt, psamples, numsamples, mode);	
	DSP_BW_Work(ModRes, aux, numsamples, mode);	
	
		do{
		*psamples+=*aux;
		aux++;
		psamples++;
		}while(--numsamples);
	
	return true;
	}
	else
	return false;
}

// That's all folks!
// Ynzn
// cjan5813@alu-etsetb.upc.es