//  Amplitude Modulator SourceCode.  Fast version.
//  If you don't know how a demultiplexion works you'll
//  find difficult to separate the demux part and the modulation
//  part in this code, so you should look at the other file.
//  This one is a lot more faster.
//
//  I have to thank Oskari for his help.
//  Ynzn

#include "MachineInterface.h"
#include "dsplib.h"

CMachineParameter const paraModcutoff =
{
	pt_word,
	"ModCutOff",
	"Modulator Filter CutOff",
	100,
	11025,
	0,
	MPF_STATE,
	11025
};


CMachineParameter const *pParameters[] =
{
	&paraModcutoff,
};

#pragma pack(1)

class gvals
{
public:
	word modcutoff;
};

#pragma pack()

CMachineInfo const MacInfo =
{
	MT_EFFECT,  // type
	MI_VERSION, // version
	0, // flags
	0, // mintracks
	0, // mxtracks
	1, // globalparams
	0, // trackparams
	pParameters,  // paramlist
	0,  // attributes
	NULL, // attribute list
	"Arguelles ADSR Filter",  // name of the machine
	"ADSR_Vcf ",  // short name
	"Arguelles", // I am the creator
	NULL  // cmdlist		  
};

//  I always get lost with CMachineInfo members.  I have to
//  put those comments.  Sorry.

class mi:public CMachineInterface
{
public:
	mi();
	virtual ~mi();
	virtual void Init(CMachineDataInput *const pi);
	virtual void Tick();
	virtual bool Work(float *psamples, int numsamples, int const mode);
	
private:
	gvals gval;
	CBWState ModFilt;
	int Modcutoff;
	
};

DLL_EXPORTS

mi::mi()
{
	GlobalVals = &gval;
	AttrVals = NULL;
	TrackVals = NULL;	   
}

mi::~mi()
{	
}

void mi::Init(CMachineDataInput * const pi)
{
	DSP_BW_Reset(ModFilt);
	Modcutoff=11025;
}


void mi::Tick()
{
	if (gval.modcutoff != paraModcutoff.NoValue)
	{
		Modcutoff=gval.modcutoff;
		DSP_BW_InitLowpass(ModFilt,Modcutoff);
	}
	// the division has moved here.  The same effect but faster.
}

bool mi::Work(float *psamples, int numsamples, int const mode)
{	
	if (mode == WM_READWRITE)
	{
	DSP_BW_Work(ModFilt, psamples, numsamples, mode);	

	return true;
	}
	else
	return false;

}

// That's all folks!
// Ynzn
// cjan5813@alu-etsetb.upc.es