/*
 just got an idea how to make a fast bassdrum algorithm without use of
trigonometrical functions or lookup tables
 in the inner loop. this one uses only 8 fmuls, 4 fadds...

 the algo is easy:
   we have two complex numbers "dr" and "ddr".
   "dr" specifies an angular rotation of "da" radians anticlockwise, while
"ddr" specifies a much smaller angular
   rotation clockwise. now, in the main loop we just take some third complex
number "r" and continuously multiply
   it by "dr" -- this way we perform a continuous rotation. this would
produce a steady sinusoidal waveform (i.e.
   constant frequency). now, if we also start multiplying "dr" by "ddr"
which goes the opposite direction, "dr"
   will steadily become smaller (i.e. the rotation angles will get smaller
and thus the frequency smaller too).
   what we've got here is simple frequency modulation with the frequency
being high at the start and continuously
   getting smaller, i.e. the tune starting at a high pitch and ending at a
low one, and that's exactly how bassdrum
   sounds are generated.
   there are a lot of other ways do make bassdrum sounds though. some do it
by filtering white noise starting at a
   high cutoff frequency and ending at a low one. to give this sound a more
"natural" touch you may also add some
   noise, perform some clipping etc.
   feel free to experiment! hearing the same odd 909's all the time is
getting boring anyway.. we should always be
   in search of new exciting sounds ;)

 btw: there are faster algorithms available to calculate steady sinus
waveforms than the complex exponential one
 i use here...

 mail me if you want the CSoundIO source too, which is not by me, but an
adaptation i made from the directsound
 playback code of stk98 by perry r cook.

 (c) 1998 jan marguc aka fontex^k
*/

#include <conio.h>
#include <math.h>
#include "soundio.h"

const blocksize = 256;

class cplx
{
public:
 double real;
 double imag;

 cplx ()
 {
  real = 0.0;
  imag = 0.0;
 };

 cplx (double real, double imag)
 {
  this->real = real;
  this->imag = imag;
 };

 void operator *= (const cplx &c)
 {
  double tmp = real * c.real - imag * c.imag;
  imag = real * c.imag + imag * c.real;
  real = tmp;
 };

 void set (double real, double imag)
 {
  this->real = real;
  this->imag = imag;
 };
};

main ()
{
 short *buffer = new short [blocksize];

 CSoundIO sound (11025, 1, blocksize);

 const double da = 0.2;
 const double dda = -0.00025;

 cplx r;
 cplx dr;
 cplx ddr;

 while (!kbhit ())
 {
  // this is the only place that we use trigonometric functions
  r.set (1.0, 0.0);
  dr.set (cos (da), sin (da));
  ddr.set (cos (dda), sin (dda));

  for (int n = 0; n < 20; n++)
  {
   for (int t = 0; t < blocksize; t++)
   {
    double tmp = 0.0;

    if (dr.imag > 0.0)
    {
     // distortion -- simple clipping
     tmp = r.real * 170000.0;
     if (tmp < -32767.0) tmp = -32767.0;
     if (tmp >  32767.0) tmp =  32767.0;

     r *= dr;
     dr *= ddr;
    }

    buffer [t] = tmp;
   }

   sound.playBuffer (buffer);
  }
 }
}

