
#include <string.h>
#include <stdlib.h>
#include <assert.h>
#include <math.h>
#include "../MachineInterface.h"

CMachineParameter const paraSeekRate = 
{ 
	pt_word,										// type
	"Rate",
	"Change Rate (half life in ms)",				// description
	1,												// MinValue	
	0xFFFF,											// MaxValue
	0,												// NoValue
	MPF_STATE,										// Flags
	125
};

CMachineParameter const paraInit = 
{ 
	pt_word,										// type
	"Initial",
	"Pulse Level [initialise] (0=0%, 8000=100%, FFFE=~200%)",	// description
	0,												// MinValue	
	0xfffe,											// MaxValue
	0xffff,    										// NoValue
	MPF_STATE,										// Flags
	0x8000
};

CMachineParameter const paraTarget = 
{ 
	pt_word,										// type
	"Target",
	"Pulse Level [target] (0=0%, 8000=100%, FFFE=~200%)",	// description
	0,												// MinValue	
	0xfffe,											// MaxValue
	0xffff,    										// NoValue
	MPF_STATE,										// Flags
	0x8000
};


CMachineParameter const *pParameters[] = 
{ 
	// global
	&paraSeekRate,
	&paraInit,
	&paraTarget
};

#pragma pack(1)		

class gvals
{
public:
	word seek_rate;
	word initial;
	word target;
};

#pragma pack()

CMachineInfo const MacInfo = 
{
	MT_EFFECT,								// type
	MI_VERSION,	
	0,										// flags
	0,										// min tracks
	0,										// max tracks
	3,										// numGlobalParameters
	0,										// numTrackParameters
	pParameters,
	0,
	NULL,
#ifdef _DEBUG
	"Pulsify v1.0(Debug build)",		// name
#else
	"Pulsify v1.0",					// name
#endif
	"Pulsify",								// short name
	"Steve Horne",							// author
	NULL
};


class mi : public CMachineInterface
{
public:
	mi();
	virtual ~mi();

	virtual void Init(CMachineDataInput * const pi);
	virtual void Tick();
	virtual bool Work(float *psamples, int numsamples, int const mode);

private:
			
	

private:
	float AttackA;
	float AttackB;
	
	float Target;
	float Current;

	float Amp;

	gvals gval;

};

DLL_EXPORTS

mi::mi()
{
	GlobalVals = &gval;
//	AttrVals = (int *)&aval;
}

mi::~mi()
{
}

void mi::Init(CMachineDataInput * const pi)
{
	AttackA = pow(2.0, -1000.0 / (((double) pMasterInfo->SamplesPerSec) * 125.0));
	AttackB = 1.0 - AttackA;
	
	Target  = 1.0;
	Current = 1.0;

	Amp   = 0.0;
}

void mi::Tick()
{
	if (gval.seek_rate != paraSeekRate.NoValue)
	{
		AttackA = pow(2.0, -1000.0 / (((double) pMasterInfo->SamplesPerSec) * ((float) gval.seek_rate)));
		AttackB = 1.0 - AttackA;
	}

	if (gval.initial != paraInit.NoValue)
	{
		Current = ((float) gval.initial) / 32768.0;
		Target  = Current;
	}

	if (gval.target != paraTarget.NoValue)
	{
		Target = ((float) gval.target) / 32768.0;
	}
}


bool mi::Work(float *psamples, int numsamples, int const mode)
{
	if (mode == WM_WRITE || mode == WM_NOIO)
		return false;
	
	if (mode == WM_READ)
		return true;

	do
	{
		Current = (Current * AttackA) + (Target * AttackB);

		if (*psamples >= 0)
		{
			Amp = (0.999 * Amp) + (0.001 * (*psamples));


			(*psamples) = ((1.0 - Current) * (*psamples)) + (Amp * Current);
		}
		else
		{
			Amp = (0.999 * Amp) - (0.001 * (*psamples));

			(*psamples) = ((1.0 - Current) * (*psamples)) - (Amp * Current);
		}


		psamples++;
	} while (--numsamples);

	return true;
}
