%
% ----------------------------------------------------------
% function to bilinear transform the numerator and denominator
% coefficients and return four z transform coefficients for direct
% form II realization using the iir filter program.
%
% Stores the 4 IIR coefficients in array pointed by zcoef
%
% Arguments:
%    num   - numerator coefficients (a2, a1, a0)
%    den   - denominator coefficients (b2, b1, b0)
%    zcoef - input (s) and output (z) coefficients
%    Fs    - Sampling Frequency (Hz)
%    k     - overall gain factor
% ----------------------------------------------------------
%
function [alpha, beta, k] = bilin(num, den, k, Fs)

% alpha nominator
ad = 4. * num(1) * Fs^2 + 2. * num(2) * Fs + num(3);

% beta denominator */
bd = 4. * den(1) * Fs^2 + 2. * den(2) * Fs + den(3);

% update gain constant for this section
k = k * (ad / bd);

% Denominator
beta(1) = 1.0; % b0
%beta(1) = den(1);
beta(2) = (2. * den(3) - 8. * den(1) * Fs^2) / bd; % b1
beta(3) = (4. * den(1) * Fs^2 - 2. * den(2) * Fs + den(3)) / bd; % b2

% Nominator
alpha(1) = 1.0; % a0
%alpha(1) = num(1);
alpha(2) = (2. * num(3) - 8. * num(1) * Fs^2) / ad; % a1
alpha(3) = (4. * num(1) * Fs^2 - 2. * num(2) * Fs + num(3)) / ad; % a2

