%
% ----------------------------------------------------------
% function to bilinear transform the numerator and denominator
% coefficients and return four z transform coefficients for direct
% form II realization using the iir filter program.
%
% Stores the 4 IIR coefficients in array pointed by zcoef
%
% Arguments:
%    num   - numerator coefficients (a2, a1, a0)
%    den   - denominator coefficients (b2, b2, b0)
%    Fs    - Sampling Frequency (Hz)
%    Fc    - Cutoff Frequency (Hz)
%    k     - overall gain factor
% ----------------------------------------------------------
%
function [alpha, beta, k] = bl(num, den, k, Fs, Fc)

%fs = 1.0;
%fc = Fc/(Fs/2);
fs = Fs;
fc = Fc;

[num] = prewarp(num, fc, fs);
[den] = prewarp(den, fc, fs);
[alpha, beta, k] = bilin(num, den, k, fs);

