% 6th order low pass resonant filter with variable
% freq cutoff and Q.
% Set your Q variable outside this module to a desired value
% before you execute this script.
% Q=1 - Standard filter without resonance
% Q > 1 - Resonant filter
% This filter is made out of 2nd order sections

%Fs = 20000;
%Fc = 4000;

bn=0;
if (bn)
   Fcn = fc / (fs / 2);   % normalized Cutoff frequency
   Fsn = 1;    % normalized Sampling frequency
   PFc = fc;
else
   Fcn = fc;
   Fsn = fs;
   %   PFc = 2 * pi * Fc;
   PFc = 1;
%   PFc = Fcn;
end

% Set PFc = 1, else it does not werk
%   PFc = Fc;

ZM=[0 0 PFc^2];

% s^2, s^1, s^0
P1 = [1 0.517638 * PFc / Q PFc^2]; % denominators of butter poly
P2 = [1 1.414214 * PFc / Q PFc^2];
P3 = [1 1.931852 * PFc / Q PFc^2];
P1 = [1 0.517638 / Q 1]; % denominators of butter poly
P2 = [1 1.414214 / Q 1];
P3 = [1 1.931852 / Q 1];
% Slight improvement for higher Q could be achieved
% if all poles are brought to the same angle in s-domain
% which would make all the Qs equal and improve the overall Q
% of entire filter. But this gain seems to be marginal
%P1 = [1 1 / Q 1]; % denominators of butter poly
%P2 = [1 1 / Q 1];
%P3 = [1 1 / Q 1];

%ZM=[.268855 0.0 1.0626604];   % a2,a1,a0
%PM1 = [1.0 .16116 1.0626604]; % den b2, b1, b0

k = 1.0;    % Overall filter gain

% s^2, s^1, s^0
ZM1=[0 0 1];
[ze0, pe0] = bilinear(ZM1, P1, Fsn, Fcn); % section 1

k = 1.0;    % Overall filter gain
[ze1, pe1, k] = bl(ZM1, P1, k, Fsn, Fcn); % section 1
[ze2, pe2, k] = bl(ZM1, P2, k, Fsn, Fcn); % section 2
[ze3, pe3, k] = bl(ZM1, P3, k, Fsn, Fcn); % section 3
zn = conv(conv(ze1,ze2),ze3);
pn = conv(conv(pe1,pe2),pe3);
freqz(zn*k, pn, 128, Fs); % chart frequency response

PPFc = 2 * pi * Fc;
Z1_3=[PPFc^2];
PP1 = [1 0.517638 * PPFc / Q PPFc^2]; % denominators of butter poly
PP2 = [1 1.414214 * PPFc / Q PPFc^2];
PP3 = [1 1.931852 * PPFc / Q PPFc^2];
[zd1, pd1] = bilinear(Z1_3, PP1, Fs, Fc); % section 1
[zd2, pd2] = bilinear(Z1_3, PP2, Fs, Fc); % section 2
[zd3, pd3] = bilinear(Z1_3, PP3, Fs, Fc); % section 3

% convolve individual sections into a single polinomial
% in order to chart the frequency response
num = conv(conv(zd1,zd2),zd3);
den = conv(conv(pd1,pd2),pd3);

% freqz(num,den,128,Fs); % chart frequency response
 
% zplane(num, den);

[z,p] = butter(6, Fc /(Fs/2)); % compare it with butterworth Q=1

