%
% ----------------------------------------------------------
% function to prewarp the coefficients of numerator or
% denominator
% Arguments:
%  Fs - Sampling Frequency
%  Fc - Cutoff Frequency
%  a - numerator/denominator coefficients of s function
%      (a2, a1, a0)
% ----------------------------------------------------------
%
function [aout] = prewarp(a, Fc, Fs)

pi = 4.0 * atan(1.0);
wp = 2.0 * Fs * tan(pi * Fc / Fs);

aout(1) = a(1) / wp^2; % a2
aout(2) = a(2) / wp;   % a1
aout(3) = a(3);        % a0
