#pragma optimize ("a", on)

#include "nr_lib.h"

///////////////////////////////////////////////////////////////////////////////
//
//  class c_Decay_Global
//

c_Decay_Global::c_Decay_Global (int p_Samples_Per_Sec)
{
  f_Samples_Per_Sec = p_Samples_Per_Sec;

  Tick (500, 500);  //  Set defaults
}

///////////////////////////////////////////////////////////////////////////////

void c_Decay_Global::Tick (int p_Attack, int p_Decay)
{
  if (p_Attack != 0)
  {
    f_Attack_A = pow (2.0, -1000.0 / (((float) f_Samples_Per_Sec) * ((float) p_Attack)));
    f_Attack_B = 1.0 - f_Attack_A;
  }

  if (p_Decay != 0)
  {
    f_Decay_A = pow (2.0, -1000.0 / (((float) f_Samples_Per_Sec) * ((float) p_Decay)));
  }
}

///////////////////////////////////////////////////////////////////////////////
//
//  class c_Decay_Track
//

c_Decay_Track::c_Decay_Track (const c_Decay_Global &p_Global)
{
  f_Global  = &p_Global;

  f_Static  = true;
  f_On      = false;
  f_Set     = 1.0;

  f_Target  = 0.0;
  f_Current = 0.0;
}

///////////////////////////////////////////////////////////////////////////////

void c_Decay_Track::Stop (void)
{
  f_Static  = true;
  f_On      = false;
  f_Set     = 1.0;

  f_Target  = 0.0;
  f_Current = 0.0;
}

///////////////////////////////////////////////////////////////////////////////

void c_Decay_Track::Tick (int p_Note, int p_Volume, int p_Init)
{
  if (p_Init != 0xff)
  {
    f_Current = ((float) p_Init) * (1.0 / 0x80);
    f_Set     = f_Current;
    f_Static  = false;
  }

  if (p_Volume != 0xff)
  {
    f_Set = ((float) p_Volume) * (1.0 / 0x80);
    f_Static = false;
  }

  if (p_Note == NOTE_OFF)
  {
    f_Static = false;
    f_On     = false;
    f_Target = 0.0;
  }
  else if (p_Note != NOTE_NO)
  {
    f_Static = false;
    f_On     = true;
    f_Target = f_Set;
  }
  else if (f_On)
  {
    f_Target = f_Set;
  }
}

///////////////////////////////////////////////////////////////////////////////

bool c_Decay_Track::Overwrite (float *psamples, int numsamples)
{
  int	  c = numsamples;
  float *p = psamples;

  if (f_Static)
  {
    if (f_Current == 0.0)
	{
		return false;
	}

    do
    {
      *p = f_Current;
      p++;
    } while (--c > 0);
  }
  else if (f_On)
  {
    do
    {
      *p = f_Current;

      f_Current =   (f_Current * f_Global->f_Attack_A)
                  + (f_Target  * f_Global->f_Attack_B);

      p++;
    } while (--c > 0);

    float l_Temp = f_Target - f_Current;

    if ((l_Temp < MIN_AMP) && (l_Temp > (-MIN_AMP)))
    {
      f_Current = f_Target;
      f_Static = true;
    }
  }
  else
  {
    do
    {
      *p = f_Current;

      f_Current = (f_Current * f_Global->f_Decay_A);

      p++;
    } while (--c > 0);

    if (f_Current < MIN_AMP)
    {
      f_Current = 0.0;
      f_Static  = true;
    }
  }

  return true;
}

///////////////////////////////////////////////////////////////////////////////

bool c_Decay_Track::Multiply (float *psamples, int numsamples)
{
  int	  c = numsamples;
  float *p = psamples;

  if (f_Static)
  {
    if (f_Current == 0.0)
	{
		return false;
	}

    do
    {
      *p *= f_Current;
      p++;
    } while (--c > 0);
  }
  else if (f_On)
  {
    do
    {
      *p *= f_Current;

      f_Current =   (f_Current * f_Global->f_Attack_A)
                  + (f_Target  * f_Global->f_Attack_B);

      p++;
    } while (--c > 0);

    float l_Temp = f_Target - f_Current;

    if ((l_Temp < MIN_AMP) && (l_Temp > (-MIN_AMP)))
    {
      f_Current = f_Target;
      f_Static = true;
    }
  }
  else
  {
    do
    {
      *p *= f_Current;

      f_Current = (f_Current * f_Global->f_Decay_A);

      p++;
    } while (--c > 0);

    if (f_Current < MIN_AMP)
    {
      f_Current = 0.0;
      f_Static  = true;
    }
  }

  return true;
}

///////////////////////////////////////////////////////////////////////////////
//
//  class c_Decay_Simple
//

c_Decay_Simple::c_Decay_Simple (int p_Samples_Per_Sec)
{
  f_Samples_Per_Sec = p_Samples_Per_Sec;

  Tick (1000, 0, 0);

  f_Static  = true;

  f_Target  = 0.0;
  f_Current = 0.0;
}

void c_Decay_Simple::Tick (int p_Attack, int p_Target, int p_Init)
{
  if (p_Attack != 0)
  {
    f_Attack_A = pow (2.0, -1000.0 / (((float) f_Samples_Per_Sec) * ((float) p_Attack)));
    f_Attack_B = 1.0 - f_Attack_A;
  }

  if (p_Init != 0xffff)
  {
    f_Current = ((float) p_Init) * (1.0 / 0x8000);
    f_Target  = f_Current;
    f_Static  = true;
  }

  if (p_Target != 0xffff)
  {
    f_Target = ((float) p_Target) * (1.0 / 0x8000);
    f_Static = false;
  }
}

bool c_Decay_Simple::Overwrite (float *psamples, int numsamples)
{
  int	  c = numsamples;
  float *p = psamples;

  if (f_Static)
  {
    if (f_Current == 0.0)
	{
		return false;
	}

    do
    {
      *p = f_Current;
      p++;
    } while (--c > 0);
  }
  else
  {
    do
    {
      *p = f_Current;

      f_Current =   (f_Current * f_Attack_A)
                  + (f_Target  * f_Attack_B);

      p++;
    } while (--c > 0);

    float l_Temp = f_Target - f_Current;

    if ((l_Temp < MIN_AMP) && (l_Temp > (-MIN_AMP)))
    {
      f_Current = f_Target;
      f_Static = true;
    }
  }

  return true;
}

bool c_Decay_Simple::Multiply  (float *psamples, int numsamples)
{
  int	  c = numsamples;
  float *p = psamples;

  if (f_Static)
  {
    if (f_Current == 0.0)
	{
		return false;
	}

    do
    {
      *p *= f_Current;
      p++;
    } while (--c > 0);
  }
  else
  {
    do
    {
      *p *= f_Current;

      f_Current =   (f_Current * f_Attack_A)
                  + (f_Target  * f_Attack_B);

      p++;
    } while (--c > 0);

    float l_Temp = f_Target - f_Current;

    if ((l_Temp < MIN_AMP) && (l_Temp > (-MIN_AMP)))
    {
      f_Current = f_Target;
      f_Static = true;
    }
  }

  return true;
}

void c_Decay_Simple::Stop (void)
{
  f_Static  = true;

  f_Target  = 0.0;
  f_Current = 0.0;
}

///////////////////////////////////////////////////////////////////////////////
//
//  class c_Pitch_Global
//

c_Pitch_Global::c_Pitch_Global (int p_Samples_Per_Sec)
{
  f_Samples_Per_Sec = p_Samples_Per_Sec;

  Set_Attack (500.0);
}

///////////////////////////////////////////////////////////////////////////////

void c_Pitch_Global::Tick (int p_Attack)
{
  if (p_Attack != 0)
  {
    f_Attack_A = pow (2.0, -1000.0 / (((float) f_Samples_Per_Sec) * ((float) p_Attack)));
    f_Attack_B = 1.0 - f_Attack_A;
  }
}

///////////////////////////////////////////////////////////////////////////////
//
//  class c_Pitch_Track
//

c_Pitch_Track::c_Pitch_Track (const c_Pitch_Global &p_Global)
{
  f_Global  = &p_Global;

  f_Frq_Scale = 440.0 / p_Global.f_Samples_Per_Sec;

  f_Static  = true;

  f_Target  = 0.0;
  f_Current = 0.0;
}

///////////////////////////////////////////////////////////////////////////////

void c_Pitch_Track::Stop (void)
{
  f_Static  = true;

  f_Target  = 0.0;
  f_Current = 0.0;
}

///////////////////////////////////////////////////////////////////////////////

void c_Pitch_Track::Tick (int p_Note, int p_Init)
{
  if ((p_Init != NOTE_OFF) && (p_Init != NOTE_NO))
  {
    int l_Note = ((p_Init >> 4) * 12) + (p_Init & 0x0f) - 70;

    f_Current = ((float) l_Note) * (1.0 / 12.0);
    f_Target  = f_Current;

    f_Static = false;

  }

  if (p_Note == NOTE_OFF)
  {
    f_Target = f_Current;  f_Static = true;
  }
  else if (p_Note != NOTE_NO)
  {
    int l_Note = ((p_Note >> 4) * 12) + (p_Note & 0x0f) - 70;

	f_Target = ((float) l_Note) * (1.0 / 12.0);

	f_Static = false;
  }
}

///////////////////////////////////////////////////////////////////////////////

bool c_Pitch_Track::Overwrite (float *psamples, int numsamples)
{
  int	  c = numsamples;
  float *p = psamples;

  if (f_Static)
  {
    float l_Temp = f_Frq_Scale * pow (2.0, f_Current);

    do
    {
      *p = l_Temp;
      p++;
    } while (--c > 0);
  }
  else
  {
    do
    {
      *p = f_Frq_Scale * pow (2.0, f_Current);

      f_Current =   (f_Current * f_Global->f_Attack_A)
                  + (f_Target  * f_Global->f_Attack_B);

      p++;
    } while (--c > 0);

    float l_Temp = f_Target - f_Current;

    if ((l_Temp < MIN_AMP) && (l_Temp > (-MIN_AMP)))
    {
      f_Current = f_Target;
      f_Static = true;
    }
  }

  return true;
}

///////////////////////////////////////////////////////////////////////////////

bool c_Pitch_Track::Multiply (float *psamples, int numsamples)
{
  int    c = numsamples;
  float *p = psamples;

  if (f_Static)
  {
    float l_Temp = f_Frq_Scale * pow (2.0, f_Current);

    do
    {
      *p *= l_Temp;
      p++;
    } while (--c > 0);
  }
  else
  {
    do
    {
      *p *= f_Frq_Scale * pow (2.0, f_Current);

      f_Current =   (f_Current * f_Global->f_Attack_A)
                  + (f_Target  * f_Global->f_Attack_B);

      p++;
    } while (--c > 0);

    float l_Temp = f_Target - f_Current;

    if ((l_Temp < MIN_AMP) && (l_Temp > (-MIN_AMP)))
    {
      f_Current = f_Target;
      f_Static = true;
    }
  }

  return true;
}

///////////////////////////////////////////////////////////////////////////////

bool c_ADSR_Track::Overwrite (float *psamples, int numsamples)
{
	int	  c = numsamples;
	float *p = psamples;

	if (f_Static)
	{
		if (f_Current == 0.0)  {  return false;  }

		while (c > 0)
		{
			*p = f_Current;
			p++;  c--;
		}
	}
	else
	{
		switch (f_Phase)
		{
		case 0 : //  Attack

			{
				if (f_Attack_Count < f_Global->f_Attack_Time)  //  Precaution in case of editing breaking things
				{
					float l_Scale = f_Volume * (1.0 - f_Previous) / ((float) f_Global->f_Attack_Time);
					int cc = c;

					if (cc > (f_Global->f_Attack_Time - f_Attack_Count))
					{
						cc = f_Global->f_Attack_Time - f_Attack_Count;
					}

					c -= cc;

					while (cc > 0)
					{
						f_Current = f_Previous + (((float) f_Attack_Count) * l_Scale);
						*p = f_Current;
						p++;  f_Attack_Count++;  cc--;
					}
				}

				if (f_Attack_Count >= f_Global->f_Attack_Time)  //  Reached delay phase
				{
					f_Phase = 1;
					f_Current = f_Volume;
					float l_Sustain = f_Volume * f_Global->f_Sustain;

					while (c > 0)
					{
						f_Current =   (f_Current * f_Global->f_Decay_A)
									+ (l_Sustain * f_Global->f_Decay_B);

						*p = f_Current;

						p++;  c--;
					}

				    float l_Temp = l_Sustain - f_Current;

				    if ((l_Temp < MIN_AMP) && (l_Temp > (-MIN_AMP)))
					{
						f_Current = l_Sustain;
						f_Static  = true;
					}
				}
			}

			break;
		case 1 : //  Decay/Sustain
			{
				float l_Sustain  = f_Volume  * f_Global->f_Sustain;
				float l_Sustain2 = l_Sustain * f_Global->f_Decay_B;

				while (c > 0)
				{
					f_Current = (f_Current * f_Global->f_Decay_A) + l_Sustain2;

					*p = f_Current;

					p++;  c--;
				}

				float l_Temp = l_Sustain - f_Current;

				if ((l_Temp < MIN_AMP) && (l_Temp > (-MIN_AMP)))
				{
					f_Current = l_Sustain;
					f_Static  = true;
				}
			}

			break;
		case 2 : //  Release
			{
				while (c > 0)
				{
					f_Current = f_Current * f_Global->f_Release_A;

					*p = f_Current;

					p++;  c--;
				}

			    if (f_Current < MIN_AMP)
				{
					f_Current = 0.0;
					f_Static  = true;
				}
			}

			break;
		}
	}

	return true;
}

///////////////////////////////////////////////////////////////////////////////

bool c_ADSR_Track::Multiply  (float *psamples, int numsamples)
{
	int	  c = numsamples;
	float *p = psamples;

	if (f_Static)
	{
		if (f_Current == 0.0)  {  return false;  }

		while (c > 0)
		{
			*p *= f_Current;
			p++;  c--;
		}
	}
	else
	{
		switch (f_Phase)
		{
		case 0 : //  Attack

			{
				if (f_Attack_Count < f_Global->f_Attack_Time)  //  Precaution in case of editing breaking things
				{
					float l_Scale = f_Volume * (1.0 - f_Previous) / ((float) f_Global->f_Attack_Time);
					int cc = c;

					if (cc > (f_Global->f_Attack_Time - f_Attack_Count))
					{
						cc = f_Global->f_Attack_Time - f_Attack_Count;
					}

					c -= cc;

					while (cc > 0)
					{
						f_Current = f_Previous + (((float) f_Attack_Count) * l_Scale);
						*p *= f_Current;
						p++;  f_Attack_Count++;  cc--;
					}
				}

				if (f_Attack_Count >= f_Global->f_Attack_Time)  //  Reached delay phase
				{
					f_Phase = 1;
					f_Current = f_Volume;
					float l_Sustain = f_Volume * f_Global->f_Sustain;

					while (c > 0)
					{
						f_Current =   (f_Current * f_Global->f_Decay_A)
									+ (l_Sustain * f_Global->f_Decay_B);

						*p *= f_Current;

						p++;  c--;
					}

				    float l_Temp = l_Sustain - f_Current;

				    if ((l_Temp < MIN_AMP) && (l_Temp > (-MIN_AMP)))
					{
						f_Current = l_Sustain;
						f_Static  = true;
					}
				}
			}

			break;
		case 1 : //  Decay/Sustain
			{
				float l_Sustain  = f_Volume  * f_Global->f_Sustain;
				float l_Sustain2 = l_Sustain * f_Global->f_Decay_B;

				while (c > 0)
				{
					f_Current = (f_Current * f_Global->f_Decay_A) + l_Sustain2;

					*p *= f_Current;

					p++;  c--;
				}

			    float l_Temp = l_Sustain - f_Current;

				if ((l_Temp < MIN_AMP) && (l_Temp > (-MIN_AMP)))
				{
					f_Current = l_Sustain;
					f_Static  = true;
				}
			}

			break;
		case 2 : //  Release
			{
				while (c > 0)
				{
					f_Current = f_Current * f_Global->f_Release_A;

					*p *= f_Current;

					p++;  c--;
				}

			    if (f_Current < MIN_AMP)
				{
					f_Current = 0.0;
					f_Static  = true;
				}
			}

			break;
		}
	}

	return true;
}

///////////////////////////////////////////////////////////////////////////////
//  ADSR2 - variant of ADSR used for modulators
//
//  Significantly more optimisation possibly in cases such as when the start
//  level and peak level are equal. Particularly useful in the case where all
//  levels are 1, indicating that the envelope is effectively switched off.

bool c_ADSR2_Track::Overwrite (float *psamples, int numsamples)
{
	int	  c = numsamples;
	float *p = psamples;

	if (f_Static)
	{
		if (f_Current == 0.0)  {  return false;  }

		while (c > 0)
		{
			*p = f_Current;
			p++;  c--;
		}
	}
	else
	{
		switch (f_Phase)
		{
		case 0 : //  Attack

			{
				if (f_Attack_Count < f_Global->f_Attack_Time)  //  Precaution in case of editing breaking things
				{
          float l_Start = f_Global->f_Start;
          float l_Peak  = f_Global->f_Peak;
					float l_Scale = (l_Peak - l_Start) / ((float) f_Global->f_Attack_Time);
					int cc = c;

					if (cc > (f_Global->f_Attack_Time - f_Attack_Count))
					{
						cc = f_Global->f_Attack_Time - f_Attack_Count;
					}

					c -= cc;

					while (cc > 0)
					{
						f_Current = l_Start + (((float) f_Attack_Count) * l_Scale);
						*p = f_Current;
						p++;  f_Attack_Count++;  cc--;
					}
				}

				if (f_Attack_Count >= f_Global->f_Attack_Time)  //  Reached delay phase
				{
					f_Phase = 1;
					f_Current = f_Global->f_Peak;
					float l_Sustain = f_Global->f_Sustain;
					float l_Decay_A = f_Global->f_Decay_A;
					float l_Decay_B = f_Global->f_Decay_B;

					while (c > 0)
					{
            f_Current =   (f_Current * l_Decay_A)
                        + (l_Sustain * l_Decay_B);

						*p = f_Current;

						p++;  c--;
					}

          float l_Temp = l_Sustain - f_Current;

          if ((l_Temp < MIN_AMP) && (l_Temp > (-MIN_AMP)))
					{
            f_Current = l_Sustain;
            f_Static  = true;
          }
				}
			}

			break;
		case 1 : //  Decay/Sustain
			{
				float l_Sustain  = f_Global->f_Sustain;
        float l_Decay_A  = f_Global->f_Decay_A;
				float l_Sustain2 = l_Sustain * f_Global->f_Decay_B;

				while (c > 0)
				{
					f_Current = (f_Current * l_Decay_A) + l_Sustain2;

					*p = f_Current;

					p++;  c--;
				}

				float l_Temp = l_Sustain - f_Current;

				if ((l_Temp < MIN_AMP) && (l_Temp > (-MIN_AMP)))
				{
					f_Current = l_Sustain;
					f_Static  = true;
				}
			}

			break;
		case 2 : //  Release
			{
				float l_End       = f_Global->f_End;
        float l_Release_A = f_Global->f_Release_A;
				float l_End2      = l_End * f_Global->f_Release_B;

				while (c > 0)
				{
					f_Current = (f_Current * l_Release_A) + l_End2;

					*p = f_Current;

					p++;  c--;
				}

				float l_Temp = l_End - f_Current;

				if ((l_Temp < MIN_AMP) && (l_Temp > (-MIN_AMP)))
				{
					f_Current = l_End;
					f_Static  = true;
				}
      }

      break;
    }
  }

  return true;
}

///////////////////////////////////////////////////////////////////////////////

bool c_ADSR2_Track::Multiply (float *psamples, int numsamples)
{
	int	  c = numsamples;
	float *p = psamples;

	if (f_Static)
	{
		if (f_Current == 0.0)  {  return false;  }

		while (c > 0)
		{
			*p *= f_Current;
			p++;  c--;
		}
	}
	else
	{
		switch (f_Phase)
		{
		case 0 : //  Attack

			{
				if (f_Attack_Count < f_Global->f_Attack_Time)  //  Precaution in case of editing breaking things
				{
          float l_Start = f_Global->f_Start;
          float l_Peak  = f_Global->f_Peak;
					float l_Scale = (l_Peak - l_Start) / ((float) f_Global->f_Attack_Time);
					int cc = c;

					if (cc > (f_Global->f_Attack_Time - f_Attack_Count))
					{
						cc = f_Global->f_Attack_Time - f_Attack_Count;
					}

					c -= cc;

					while (cc > 0)
					{
						f_Current = l_Start + (((float) f_Attack_Count) * l_Scale);
						*p *= f_Current;
						p++;  f_Attack_Count++;  cc--;
					}
				}

				if (f_Attack_Count >= f_Global->f_Attack_Time)  //  Reached delay phase
				{
					f_Phase = 1;
					f_Current = f_Global->f_Peak;
					float l_Sustain = f_Global->f_Sustain;
					float l_Decay_A = f_Global->f_Decay_A;
					float l_Decay_B = f_Global->f_Decay_B;

					while (c > 0)
					{
            f_Current =   (f_Current * l_Decay_A)
                        + (l_Sustain * l_Decay_B);

						*p *= f_Current;

						p++;  c--;
					}

          float l_Temp = l_Sustain - f_Current;

          if ((l_Temp < MIN_AMP) && (l_Temp > (-MIN_AMP)))
					{
            f_Current = l_Sustain;
            f_Static  = true;
          }
				}
			}

			break;
		case 1 : //  Decay/Sustain
			{
				float l_Sustain  = f_Global->f_Sustain;
        float l_Decay_A  = f_Global->f_Decay_A;
				float l_Sustain2 = l_Sustain * f_Global->f_Decay_B;

				while (c > 0)
				{
					f_Current = (f_Current * l_Decay_A) + l_Sustain2;

					*p *= f_Current;

					p++;  c--;
				}

				float l_Temp = l_Sustain - f_Current;

				if ((l_Temp < MIN_AMP) && (l_Temp > (-MIN_AMP)))
				{
					f_Current = l_Sustain;
					f_Static  = true;
				}
			}

			break;
		case 2 : //  Release
			{
				float l_End       = f_Global->f_End;
        float l_Release_A = f_Global->f_Release_A;
				float l_End2      = l_End * f_Global->f_Release_B;

				while (c > 0)
				{
					f_Current = (f_Current * l_Release_A) + l_End2;

					*p *= f_Current;

					p++;  c--;
				}

				float l_Temp = l_End - f_Current;

				if ((l_Temp < MIN_AMP) && (l_Temp > (-MIN_AMP)))
				{
					f_Current = l_End;
					f_Static  = true;
				}
      }

      break;
    }
  }

  return true;
}

///////////////////////////////////////////////////////////////////////////////
