//
//  Fractal effect related stuff
//

#pragma optimize ("a", on)

#include "fractal.h"

class c_Fractal_Private
{
public:
	float f_Effect_Hi;
	float f_Effect_Lo;
	byte  f_Depth;
	bool  f_Static;

  bool  f_Precalc1_Done;
  bool  f_Precalc2_Done;
  bool  f_Optimise_Enable;
  int   f_Optimise_Quality;

  float f_Precalc1 [NR_LIB_FRACTAL_MAX_QUALITY];
  float f_Precalc2 [NR_LIB_FRACTAL_MAX_QUALITY];
};

c_Fractal::c_Fractal  (void)
{
	f_Private = new c_Fractal_Private;

  f_Private->f_Precalc1_Done    = false;
  f_Private->f_Precalc2_Done    = false;
  f_Private->f_Optimise_Enable  = false;
  f_Private->f_Optimise_Quality = NR_LIB_FRACTAL_MAX_QUALITY;

	f_Private->f_Effect_Hi = (((float) 32768) * (float) 9.0) / ((float) 65534);
	f_Private->f_Effect_Lo = (((float) 32768) * (float) 9.0) / ((float) 65534);
	f_Private->f_Depth     = 1;
	f_Private->f_Static    = true;
}

c_Fractal::~c_Fractal (void)
{
	delete f_Private;
}

void c_Fractal::Set_Optimise_Enable  (bool p_Enable)
{
  f_Private->f_Optimise_Enable = p_Enable;
}

void c_Fractal::Set_Optimise_Quality (int  p_Quality)
{
  if (   (f_Private->f_Optimise_Quality != p_Quality)
      && (p_Quality >= 2)
      && (p_Quality <= NR_LIB_FRACTAL_MAX_QUALITY))
  {
    f_Private->f_Optimise_Quality = p_Quality;
    f_Private->f_Precalc1_Done     = false;
    f_Private->f_Precalc2_Done     = false;
  }
}

bool c_Fractal::Get_Optimise_Enable  (void)
{
  return f_Private->f_Optimise_Enable;
}

int  c_Fractal::Get_Optimise_Quality (void)
{
  return f_Private->f_Optimise_Quality;
}

void c_Fractal::Set_Depth (int p_Depth)
{
  if (f_Private->f_Depth != p_Depth)
  {
    f_Private->f_Depth = p_Depth;

    if (   (f_Private->f_Depth == 0)
        || (f_Private->f_Effect_Hi == f_Private->f_Effect_Lo))
    {
      f_Private->f_Static = true;
    }
    else
    {
      f_Private->f_Static = false;
    }

    f_Private->f_Precalc1_Done = false;
    f_Private->f_Precalc2_Done = false;
  }
}

void c_Fractal::Set_Effect_Hi (float p_Effect_Hi)
{
  if (f_Private->f_Effect_Hi != p_Effect_Hi)
  {
		f_Private->f_Effect_Hi = p_Effect_Hi;

		if (   (f_Private->f_Depth == 0)
				|| (f_Private->f_Effect_Hi == f_Private->f_Effect_Lo))
		{
			f_Private->f_Static = true;
		}
		else
		{
			f_Private->f_Static = false;
		}

    f_Private->f_Precalc1_Done = false;
  }
}

void c_Fractal::Set_Effect_Lo (float p_Effect_Lo)
{
  if (f_Private->f_Effect_Lo != p_Effect_Lo)
  {
		f_Private->f_Effect_Lo = p_Effect_Lo;

		if (   (f_Private->f_Depth == 0)
				|| (f_Private->f_Effect_Hi == f_Private->f_Effect_Lo))
		{
			f_Private->f_Static = true;
		}
		else
		{
			f_Private->f_Static = false;
		}

    f_Private->f_Precalc2_Done = false;
  }
}

int c_Fractal::Get_Depth (void)
{
	return f_Private->f_Depth;
}

float c_Fractal::Get_Effect_Hi (void)
{
	return f_Private->f_Effect_Hi;
}

float c_Fractal::Get_Effect_Lo (void)
{
	return f_Private->f_Effect_Lo;
}

void c_Fractal::Set_Fractal_Pars (word p_Effect_Hi, word p_Effect_Lo, byte p_Depth)
{
	if (p_Effect_Hi != 0xffff)
	{
    Set_Effect_Hi ((((float) p_Effect_Hi) * (float) 9.0) / ((float) 65534));
	}

	if (p_Effect_Lo != 0xffff)
	{
    Set_Effect_Lo ((((float) p_Effect_Lo) * (float) 9.0) / ((float) 65534));
	}

	if (p_Depth != 0xff)
	{
    Set_Depth (p_Depth);
	}
}

bool c_Fractal::Is_Static (void)
{
	return f_Private->f_Static;
}

void c_Fractal::Process (float *p_Source, float *p_Effect_Mod, int numsamples)
{
	float l_Effect_C;
	float l_Effect_B;
	float l_Effect_A;
	float s, ss;
  int   n;

  if (f_Private->f_Optimise_Enable)
  {
		int	m = f_Private->f_Optimise_Quality;
    int i;
    float q = ((float) m - 1);

    if (!f_Private->f_Precalc1_Done)
    {
			l_Effect_C = f_Private->f_Effect_Hi;
			l_Effect_B = (float) 3.0 - ((float) 3.0 * l_Effect_C);
			l_Effect_A = (float) 1.0 - (l_Effect_C + l_Effect_B);

      for (i = 0; i < m; i++)
      {
        s = ((float) i) / q;

				if (s < 0.0)
				{
					s = 0.0;
				}
				else if (s > 1.0)
				{
					s = 1.0;
				}

				n = f_Private->f_Depth;

				while (n-- > 0)
				{
					ss = s * s;

					s =   (l_Effect_A * ss * s)
		 					+ (l_Effect_B * ss    )
							+ (l_Effect_C * s     );
				}

				if (s < 0.0)
				{
					s = 0.0;
				}
				else if (s > 1.0)
				{
					s = 1.0;
				}

        f_Private->f_Precalc1 [i] = (s * (float) 2.0) - (float) 1.0;
      }

      f_Private->f_Precalc1_Done = true;
    }

    if (!f_Private->f_Precalc2_Done)
    {
			l_Effect_C = f_Private->f_Effect_Lo;
			l_Effect_B = (float) 3.0 - ((float) 3.0 * l_Effect_C);
			l_Effect_A = (float) 1.0 - (l_Effect_C + l_Effect_B);

      for (i = 0; i < m; i++)
      {
        s = ((float) i) / q;

				if (s < 0.0)
				{
					s = 0.0;
				}
				else if (s > 1.0)
				{
					s = 1.0;
				}

				n = f_Private->f_Depth;

				while (n-- > 0)
				{
					ss = s * s;

					s =   (l_Effect_A * ss * s)
		 					+ (l_Effect_B * ss    )
							+ (l_Effect_C * s     );
				}

				if (s < 0.0)
				{
					s = 0.0;
				}
				else if (s > 1.0)
				{
					s = 1.0;
				}

        f_Private->f_Precalc2 [i] = (s * (float) 2.0) - (float) 1.0;
      }

      f_Private->f_Precalc2_Done = true;
    }

    s = ((float) m) / (float) 2.0;

    float *l_Precalc1 = f_Private->f_Precalc1;
    float *l_Precalc2 = f_Private->f_Precalc2;

    do
    {
      i = (int) ((*p_Source + (float) 1.0) * s);
      ss = l_Precalc2 [i] - l_Precalc1 [i];

      *p_Source = l_Precalc1 [i] + ((*p_Effect_Mod) * ss);

			p_Source++;  p_Effect_Mod++;
		} while (--numsamples > 0);
  }
  else
  {
		float l_Effect_Lo   = f_Private->f_Effect_Lo;
		float l_Effect_Diff = f_Private->f_Effect_Hi - l_Effect_Lo;

		do
		{
			l_Effect_C = l_Effect_Lo + (l_Effect_Diff * (*p_Effect_Mod));
			l_Effect_B = (float) 3.0 - ((float) 3.0 * l_Effect_C);
			l_Effect_A = (float) 1.0 - (l_Effect_C + l_Effect_B);

			s = (*p_Source + (float) 1.0) / (float) 2.0;

			if (s < 0.0)
			{
				s = 0.0;
			}
			else if (s > 1.0)
			{
				s = 1.0;
			}

			n = f_Private->f_Depth;

			while (n-- > 0)
			{
				ss = s * s;

				s =   (l_Effect_A * ss * s)
					+ (l_Effect_B * ss    )
					+ (l_Effect_C * s     );
			}

			if (s < 0.0)
			{
				s = 0.0;
			}
			else if (s > 1.0)
			{
				s = 1.0;
			}

			*p_Source = (s * (float) 2.0) - (float) 1.0;

			p_Source++;  p_Effect_Mod++;
		} while (--numsamples > 0);
  }
}

void c_Fractal::Process_Static (float *p_Source, float  p_Effect_Mod, int numsamples)
{
	if (f_Private->f_Static)
	{
		if (f_Private->f_Depth     == 0  )  {  return;  }  //  If fractal will have no effect, exit
		if (f_Private->f_Effect_Hi == 1.0)  {  return;  }  //  No point testing f_Effect_Lo, as == f_Effect_Hi here
	}

  float l_Effect_C;
  float l_Effect_B;
  float l_Effect_A;
  float s, ss;
  int   n;

  if (f_Private->f_Optimise_Enable)
  {
		int	m = f_Private->f_Optimise_Quality;
    int i;
    float q = ((float) m - 1);

    if (!f_Private->f_Precalc1_Done)
    {
			l_Effect_C = f_Private->f_Effect_Hi;
			l_Effect_B = (float) 3.0 - ((float) 3.0 * l_Effect_C);
			l_Effect_A = (float) 1.0 - (l_Effect_C + l_Effect_B);

      for (i = 0; i < m; i++)
      {
        s = ((float) i) / q;

				if (s < 0.0)
				{
					s = 0.0;
				}
				else if (s > 1.0)
				{
					s = 1.0;
				}

				n = f_Private->f_Depth;

				while (n-- > 0)
				{
					ss = s * s;

					s =   (l_Effect_A * ss * s)
		 					+ (l_Effect_B * ss    )
							+ (l_Effect_C * s     );
				}

				if (s < 0.0)
				{
					s = 0.0;
				}
				else if (s > 1.0)
				{
					s = 1.0;
				}

        f_Private->f_Precalc1 [i] = (s * (float) 2.0) - (float) 1.0;
      }

      f_Private->f_Precalc1_Done = true;
    }

    if (!f_Private->f_Precalc2_Done)
    {
			l_Effect_C = f_Private->f_Effect_Lo;
			l_Effect_B = (float) 3.0 - ((float) 3.0 * l_Effect_C);
			l_Effect_A = (float) 1.0 - (l_Effect_C + l_Effect_B);

      for (i = 0; i < m; i++)
      {
        s = ((float) i) / q;

				if (s < 0.0)
				{
					s = 0.0;
				}
				else if (s > 1.0)
				{
					s = 1.0;
				}

				n = f_Private->f_Depth;

				while (n-- > 0)
				{
					ss = s * s;

					s =   (l_Effect_A * ss * s)
		 					+ (l_Effect_B * ss    )
							+ (l_Effect_C * s     );
				}

				if (s < 0.0)
				{
					s = 0.0;
				}
				else if (s > 1.0)
				{
					s = 1.0;
				}

        f_Private->f_Precalc2 [i] = (s * (float) 2.0) - (float) 1.0;
      }

      f_Private->f_Precalc2_Done = true;
    }

    s = ((float) m) / 2.0;

    float *l_Precalc1 = f_Private->f_Precalc1;
    float *l_Precalc2 = f_Private->f_Precalc2;

    do
    {
      i = ((*p_Source + (float) 1.0) * s);
      ss = l_Precalc2 [i] - l_Precalc1 [i];

      *p_Source = l_Precalc1 [i] + (p_Effect_Mod * ss);

			p_Source++;  p_Effect_Mod++;
		} while (--numsamples > 0);
  }
  else
  {
    {
      float l_Effect_Lo   = f_Private->f_Effect_Lo;
      float l_Effect_Diff = f_Private->f_Effect_Hi - l_Effect_Lo;

      l_Effect_C = l_Effect_Lo + (l_Effect_Diff * p_Effect_Mod);
      l_Effect_B = (float) 3.0 - ((float) 3.0 * l_Effect_C);
      l_Effect_A = (float) 1.0 - (l_Effect_C + l_Effect_B);
    }

    do
    {
      s = (*p_Source + (float) 1.0) / (float) 2.0;

      if (s < 0.0)
      {
        s = 0.0;
      }
      else if (s > 1.0)
      {
        s = 1.0;
      }

      n = f_Private->f_Depth;

      while (n-- > 0)
      {
        ss = s * s;

        s =   (l_Effect_A * ss * s)
          + (l_Effect_B * ss    )
          + (l_Effect_C * s     );
      }

      if (s < 0.0)
      {
        s = 0.0;
      }
      else if (s > 1.0)
      {
        s = 1.0;
      }

      *p_Source = (s * (float) 2.0) - (float) 1.0;

      p_Source++;
    } while (--numsamples > 0);
  }
}

