//
//  Fractal Effect
//

#ifndef __NR_LIB_FRACTAL_HEAD
#define __NR_LIB_FRACTAL_HEAD

#include <math.h>
#include <float.h>
#include "../MachineInterface.h"

#define NR_LIB_FRAC_EFFECT_PAR(p_Var,p_Name,p_Desc)	\
CMachineParameter const p_Var =						\
{													\
	pt_word,										\
	p_Name,											\
	p_Desc,											\
	0,												\
	0xfffe,											\
	0xffff,											\
	MPF_STATE,										\
	0x8000,											\
};

#define NR_LIB_FRAC_DEPTH_PAR(p_Var,p_Name,p_Desc)	\
CMachineParameter const p_Var =						\
{													\
	pt_byte,										\
	p_Name,											\
	p_Desc,											\
	0,												\
	10,												\
	0xff,											\
	MPF_STATE,										\
	0x01											\
};

#define NR_LIB_FRACTAL_MAX_QUALITY 2048

class c_Fractal_Private;

class c_Fractal
{
private:

	c_Fractal_Private *f_Private;

public:

	c_Fractal  (void);
	~c_Fractal (void);

	void Set_Depth		(int   p_Depth    );
	void Set_Effect_Hi	(float p_Effect_Hi);
	void Set_Effect_Lo	(float p_Effect_Lo);

  void Set_Optimise_Enable  (bool p_Enable);
  void Set_Optimise_Quality (int  p_Quality);

	int   Get_Depth		(void);
	float Get_Effect_Hi	(void);
	float Get_Effect_Lo	(void);

  bool Get_Optimise_Enable  (void);
  int  Get_Optimise_Quality (void);

	void Set_Fractal_Pars (word p_Effect_Hi, word p_Effect_Lo, byte p_Depth);

	//
	//  Process should be called with a set of modulation levels in p_Effect_Mod (range 0.0 to 1.0).
	//
	//  Process_Static should be used when the fractal effect modulation is constant.
	//
	//  As the fractal is inherently static when the high and low effect values are equal, or when
	//  the depth value is zero, the Is_Static function returns true in these cases. This allows the
	//  caller to optimise by not calculating the modulating signal if appropriate.
	//
	//  An additional optimisation that may be useful is to build a lookup table for static non-chaotic
	//  settings, thus avoiding repeatedly evaluating the cubic at every point. Needs care, though, to
	//  ensure the lookup table is not calculated so often that it takes more processing than direct
	//  calculation.
	//

	bool Is_Static (void);

	void Process        (float *p_Source, float *p_Effect_Mod, int numsamples);
	void Process_Static (float *p_Source, float  p_Effect_Mod, int numsamples);
};

#endif
