#pragma optimize ("a", on)

#include "wave.h"

void Sine(float *psamples, int numsamples)
{
	do
	{
		*psamples = sin (*psamples * 2.0 * PI);

		psamples++;
	} while (--numsamples > 0);

}

void Square(float *psamples, int numsamples)
{
	do
	{
    if (*psamples < 0.5)
    {
			*psamples = 1.0;
    }
    else
    {
			*psamples = -1.0;
    }

    psamples++;

	} while (--numsamples > 0);
}

void Triangle(float *psamples, int numsamples)
{
	do
	{
    if (*psamples < 0.25)
    {
			*psamples *= 4.0;
    }
    else if (*psamples < 0.75)
    {
			*psamples = 2.0 - (*psamples * 4.0);
    }
    else
    {
			*psamples = (*psamples * 4.0) - 4.0;
    }

    psamples++;

	} while (--numsamples > 0);
}

void Ramp(float *psamples, int numsamples)
{
	do
	{
    *psamples = (*psamples * 2.0) - 1.0;

    psamples++;

	} while (--numsamples > 0);
}

void AltRamp(float *psamples, int numsamples)
{
	do
	{
    if (*psamples < 0.5)
    {
			*psamples *= 2.0;
    }
    else
    {
			*psamples = 1.0 - (*psamples * 2.0);
    }

    psamples++;

	} while (--numsamples > 0);
}

void Hex(float *psamples, int numsamples)
{
	do
	{
    if (*psamples < 0.125)
    {
			*psamples *= 8.0;
    }
    else if (*psamples < 0.375)
    {
			*psamples = 1.0;
    }
    else if (*psamples < 0.625)
    {
			*psamples = 4.0 - (*psamples * 8.0);
    }
    else if (*psamples < 0.875)
    {
			*psamples = -1.0;
    }
    else
    {
			*psamples = (*psamples * 8.0) - 8.0;
    }

    psamples++;

	} while (--numsamples > 0);
}

void Jaggy(float *psamples, int numsamples)
{
	do
	{
    *psamples *= 8.0;

    if (*psamples < 1.0)
    {
    }
    else if (*psamples < 2.0)
    {
			*psamples = 2.0 - *psamples;
    }
    else if (*psamples < 3.0)
    {
			*psamples -= 2.0;
    }
    else if (*psamples < 5.0)
    {
			*psamples = 4.0 - *psamples;
    }
    else if (*psamples < 6.0)
    {
			*psamples -= 6.0;
    }
    else if (*psamples < 7.0)
    {
			*psamples = 6.0 - *psamples;
    }
    else
    {
			*psamples -= 8.0;
    }

    psamples++;

	} while (--numsamples > 0);
}

void Jaggy2(float *psamples, int numsamples)
{
	do
	{
    *psamples *= 8.0;

    if (*psamples < 1.0)
    {
    }
    else if (*psamples < 2.0)
    {
			*psamples = 2.0 - *psamples;
    }
    else if (*psamples < 3.0)
    {
			*psamples -= 2.0;
			*psamples *= 0.5;
    }
    else if (*psamples < 5.0)
    {
			*psamples = (4.0 - *psamples) * 0.5;
    }
    else if (*psamples < 6.0)
    {
			*psamples -= 6.0;
			*psamples *= 0.5;
    }
    else if (*psamples < 7.0)
    {
			*psamples = 6.0 - *psamples;
    }
    else
    {
			*psamples -= 8.0;
    }

    psamples++;

	} while (--numsamples > 0);
}

void Bumps(float *psamples, int numsamples)
{
	do
	{
    if (*psamples < 0.5)
    {
			*psamples = ((-cos(*psamples * 4.0 * PI)) + 1.0) * 0.5;
    }
    else
    {
			*psamples = (cos(*psamples * 4.0 * PI) - 1.0) * 0.5;
    }

    psamples++;

	} while (--numsamples > 0);
}

void DblBumps(float *psamples, int numsamples)
{
	do
	{
    if (*psamples < 0.5)
    {
			*psamples = ((-cos(*psamples * 8.0 * PI)) + 1.0) * 0.5;
    }
    else
    {
			*psamples = (cos(*psamples * 8.0 * PI) - 1.0) * 0.5;
    }

    psamples++;

	} while (--numsamples > 0);
}

void AltBumps(float *psamples, int numsamples)
{
	do
	{
	  *psamples *= 6.0;

      if (*psamples < 1.0)
      {
        *psamples = ((-cos(*psamples * PI)) + 1.0) * 0.25;
      }
      else if (*psamples < 2.0)
      {
        *psamples = ((cos(*psamples * PI)) + 3.0) * 0.25;
      }
      else if (*psamples < 3.0)
      {
        *psamples = ((cos(*psamples * PI)) + 1.0) * 0.5;
      }
      else if (*psamples < 4.0)
      {
        *psamples = ((-cos(*psamples * PI)) - 1.0) * 0.25;
      }
      else if (*psamples < 5.0)
      {
        *psamples = ((cos(*psamples * PI)) - 3.0) * 0.25;
      }
      else
      {
        *psamples = ((cos(*psamples * PI)) - 1.0) * 0.5;
      }

    psamples++;

	} while (--numsamples > 0);
}

void AltBumps2(float *psamples, int numsamples)
{
	do
	{
	  *psamples *= 6.0;

      if (*psamples < 1.0)
      {
        *psamples = ((-cos(*psamples * PI)) + 1.0) * 0.25;
      }
      else if (*psamples < 2.0)
      {
        *psamples = ((cos(*psamples * PI)) + 3.0) * 0.25;
      }
      else if (*psamples < 3.0)
      {
        *psamples = ((cos(*psamples * PI)) + 1.0) * 0.5;
      }
      else if (*psamples < 4.0)
      {
        *psamples = ((-cos(*psamples * PI)) - 1.0) * 0.5;
      }
      else if (*psamples < 5.0)
      {
        *psamples = ((-cos(*psamples * PI)) - 3.0) * 0.25;
      }
      else
      {
        *psamples = ((cos(*psamples * PI)) - 1.0) * 0.25;
      }

    psamples++;

	} while (--numsamples > 0);
}

void SquareBumps(float *psamples, int numsamples)
{
	do
	{
	  *psamples *= 6.0;

      if (*psamples < 1.0)
      {
        *psamples = ((-cos(*psamples * PI)) + 1.0) * 0.5;
      }
      else if (*psamples < 2.0)
      {
        *psamples = 1.0;
      }
      else if (*psamples < 3.0)
      {
        *psamples = ((cos(*psamples * PI)) + 1.0) * 0.5;
      }
      else if (*psamples < 4.0)
      {
        *psamples = ((-cos(*psamples * PI)) - 1.0) * 0.5;
      }
      else if (*psamples < 5.0)
      {
        *psamples = -1.0;
      }
      else
      {
        *psamples = ((cos(*psamples * PI)) - 1.0) * 0.5;
      }

    psamples++;

	} while (--numsamples > 0);
}

void DblBumps2(float *psamples, int numsamples)
{
	do
	{
    if (*psamples < 0.25)
    {
			*psamples = ((-cos(*psamples * 8.0 * PI)) + 1.0) * 0.5;
    }
    else if (*psamples < 0.5)
    {
			*psamples = ((-cos(*psamples * 8.0 * PI)) + 1.0) * 0.25;
    }
    else if (*psamples < 0.75)
    {
			*psamples = (cos(*psamples * 8.0 * PI) - 1.0) * 0.25;
    }
    else
    {
			*psamples = (cos(*psamples * 8.0 * PI) - 1.0) * 0.5;
    }

    psamples++;

	} while (--numsamples > 0);
}

////////////////////////////////////////////////////////////////////

class c_Waveform_Private
{
public:
	int   f_Waveform;

  //  Precalc buffer always present, even when optimisation not used, to
  //  avoid dynamic allocations. May change, however, as this should not
  //  be a problem case - optimisation is either on or off, it will not
  //  continuously change.

  //  It is probably better to store a table of precalculated waveforms
  //  in static memory, so that they can be shared. This is not trivial,
  //  however, due to my allowing the quality to be altered.

  bool  f_Precalc_Done;
  float f_Precalc [NR_LIB_WAVEFORM_MAX_QUALITY];

  bool  f_Optimise_Enable;
  int   f_Optimise_Quality;
};

c_Waveform::c_Waveform (void)
{
	f_Private = new c_Waveform_Private;

	f_Private->f_Waveform = 1;

  f_Private->f_Precalc_Done     = false;
  f_Private->f_Optimise_Enable  = false;
  f_Private->f_Optimise_Quality = NR_LIB_WAVEFORM_MAX_QUALITY;
}

c_Waveform::~c_Waveform (void)
{
	delete f_Private;
}

void c_Waveform::Set_Waveform (int p_Waveform)
{
  if (f_Private->f_Waveform != p_Waveform)
  {
	  f_Private->f_Waveform     = p_Waveform;
    f_Private->f_Precalc_Done = false;
  }
}

int c_Waveform::Get_Waveform (void)
{
	return f_Private->f_Waveform;
}

void c_Waveform::Set_Optimise_Enable (bool p_Enable)
{
  f_Private->f_Optimise_Enable = p_Enable;
}

bool c_Waveform::Get_Optimise_Enable (void)
{
  return f_Private->f_Optimise_Enable;
}

void c_Waveform::Set_Optimise_Quality (int p_Quality)
{
  if (   (f_Private->f_Optimise_Quality != p_Quality)
      && (p_Quality <= NR_LIB_WAVEFORM_MAX_QUALITY  )
      && (p_Quality >  1                            ))
  {
	  f_Private->f_Optimise_Quality = p_Quality;
    f_Private->f_Precalc_Done = false;
  }
}

int  c_Waveform::Get_Optimise_Quality (void)
{
  return f_Private->f_Optimise_Quality;
}

void c_Waveform::Process (float *psamples, int numsamples)
{
  if (f_Private->f_Optimise_Enable)
  {
    float *l_Precalc = f_Private->f_Precalc;
    int    n = f_Private->f_Optimise_Quality;
//    float  l_Scale = (2.0 * PI) / ((float) n);
    float  l_Scale = 1.0 / ((float) n);

    if (!f_Private->f_Precalc_Done)
    {
      int    i;
      float *l_Precalc2 = l_Precalc;

      for (i = 0; i < n; i++)
      {
        *l_Precalc2 = ((float) i) * l_Scale;  l_Precalc2++;
      }

    	switch (f_Private->f_Waveform)
  	  {
  	  case  1 :  Sine        (l_Precalc, n);  break;
  	  case  2 :  Triangle    (l_Precalc, n);  break;
  	  case  3 :  Jaggy       (l_Precalc, n);  break;
  	  case  4 :  Hex         (l_Precalc, n);  break;
  	  case  5 :  Square      (l_Precalc, n);  break;
  	  case  6 :  Ramp        (l_Precalc, n);  break;
  	  case  7 :  AltRamp     (l_Precalc, n);  break;
  	  case  8 :  Bumps       (l_Precalc, n);  break;
  	  case  9 :  DblBumps    (l_Precalc, n);  break;
  	  case 10 :  AltBumps    (l_Precalc, n);  break;
  	  case 11 :  AltBumps2   (l_Precalc, n);  break;
  	  case 12 :  SquareBumps (l_Precalc, n);  break;
  	  case 13 :  DblBumps2   (l_Precalc, n);  break;
  	  case 14 :  Jaggy2      (l_Precalc, n);  break;
  	  }

      f_Private->f_Precalc_Done = true;
    }

//    l_Scale = ((float) n) / (2.0 * PI);
    l_Scale = ((float) n);

    while (numsamples > 0)
    {
      *psamples = l_Precalc [(int) (l_Scale * (*psamples))];

      psamples++;  numsamples--;
    }
  }
  else
  {
  	switch (f_Private->f_Waveform)
  	{
  	case  1 :  Sine        (psamples, numsamples);  break;
  	case  2 :  Triangle    (psamples, numsamples);  break;
  	case  3 :  Jaggy       (psamples, numsamples);  break;
  	case  4 :  Hex         (psamples, numsamples);  break;
  	case  5 :  Square      (psamples, numsamples);  break;
  	case  6 :  Ramp        (psamples, numsamples);  break;
  	case  7 :  AltRamp     (psamples, numsamples);  break;
  	case  8 :  Bumps       (psamples, numsamples);  break;
  	case  9 :  DblBumps    (psamples, numsamples);  break;
  	case 10 :  AltBumps    (psamples, numsamples);  break;
  	case 11 :  AltBumps2   (psamples, numsamples);  break;
  	case 12 :  SquareBumps (psamples, numsamples);  break;
  	case 13 :  DblBumps2   (psamples, numsamples);  break;
  	case 14 :  Jaggy2      (psamples, numsamples);  break;
  	}
  }
}

////////////////////////////////////////////////////////////////////

class c_Frq_To_Phase_Private
{
public:
	float f_Phase;
};

c_Frq_To_Phase::c_Frq_To_Phase (void)
{
	f_Private = new c_Frq_To_Phase_Private;

	f_Private->f_Phase = 0.0;
}

c_Frq_To_Phase::~c_Frq_To_Phase (void)
{
	delete f_Private;
}

void c_Frq_To_Phase::Process (float *psamples, int numsamples)
{
	float l_Phase = f_Private->f_Phase;

	do
	{
		l_Phase += *psamples;

		while (l_Phase >= 1.0)  {  l_Phase -= 1.0;  }

		*psamples = l_Phase;  psamples++;
	} while (--numsamples > 0);

	f_Private->f_Phase = l_Phase;
}

void c_Frq_To_Phase::Process (float *pdest, float *psrc, int numsamples)
{
	float l_Phase = f_Private->f_Phase;

	do
	{
		l_Phase += *psrc;

		while (l_Phase >= 1.0)  {  l_Phase -= 1.0;  }

		*pdest = l_Phase;  pdest++;  psrc++;
	} while (--numsamples > 0);

	f_Private->f_Phase = l_Phase;
}

void c_Frq_To_Phase::Process (float *psamples,           int numsamples, float p_Detune)
{
	float l_Phase = f_Private->f_Phase;

	do
	{
		l_Phase += *psamples * p_Detune;

		while (l_Phase >= 1.0)  {  l_Phase -= 1.0;  }

		*psamples = l_Phase;  psamples++;
	} while (--numsamples > 0);

	f_Private->f_Phase = l_Phase;
}

void c_Frq_To_Phase::Process (float *pdest, float *psrc, int numsamples, float p_Detune)
{
	float l_Phase = f_Private->f_Phase;

	do
	{
		l_Phase += *psrc * p_Detune;

		while (l_Phase >= 1.0)  {  l_Phase -= 1.0;  }

		*pdest = l_Phase;  pdest++;  psrc++;
	} while (--numsamples > 0);

	f_Private->f_Phase = l_Phase;
}

////////////////////////////////////////////////////////////////////
