//
//  Waveform header
//

#ifndef __NR_LIB_WAVE_HEAD
#define __NR_LIB_WAVE_HEAD

#include <math.h>
#include <float.h>
#include "../MachineInterface.h"

#define NR_LIB_HIGH_WAVEFORM  14

#define NR_LIB_WAVEFORM_PAR(p_Var,p_Name,p_Desc)	\
CMachineParameter const p_Var =						\
{													\
	pt_byte,										\
	p_Name,											\
	p_Desc,											\
	1,												\
	NR_LIB_HIGH_WAVEFORM,							\
	0,												\
	MPF_STATE,										\
	1												\
};

class c_Waveform_Private;
class c_Frq_To_Phase_Private;

#define NR_LIB_WAVEFORM_MAX_QUALITY 2048

class c_Waveform
{
private:

	c_Waveform_Private *f_Private;

public:

	 c_Waveform (void);
	~c_Waveform (void);

	void Set_Waveform (int p_Waveform);
	int  Get_Waveform (void);

  void Set_Optimise_Enable (bool p_Enable);
  bool Get_Optimise_Enable (void);

  //  If optimising is not meant to affect the sound, use the maximum setting.
  //  It may, however, be useful to reduce this for special purposes. This should
  //  not affect speed - only the enable flag will affect speed.

  void Set_Optimise_Quality (int p_Quality);
  int  Get_Optimise_Quality (void);


    //  Each of these requires phase information in the buffer before it starts
    //  (range 0.0 <= phase < 1.0), and replaces this with amplitude information
    //  ranging from -1.0 to 1.0.

	void Process (float *psamples, int numsamples);
};

//
//  The following class translates a buffer full of frequency values into a buffer
//  full of phase values, ready for waveform calculations. The main reason for
//  using a class is to store the start phase from one calculation to the next,
//  though future versions may support arpegiateurs, modulations and other
//  effects that require state information.
//
//  There are different process calls for detuned signals and for output to a
//  separate destination buffer. However, the same c_Frq_To_Phase object
//  cannot be used to generate two signals from one source (eg with one output
//  detuned) because the phase information for each signal would be corrupted
//  by the calculations for the other.
//
//  To acheive this result, simply use two c_Frq_To_Phase objects.
//
//  The detune parameters are scale factors applied to the original frequency.
//  As it is more normal specify detune as a fraction of a semitone (I assume),
//  the following conversion may be useful...
//
//    detune_factor = pow (2.0, detune_semitones / 14.0);
//

class c_Frq_To_Phase
{
private:

	c_Frq_To_Phase_Private *f_Private;

public:

	c_Frq_To_Phase (void);
	~c_Frq_To_Phase (void);

	void Process (float *psamples,           int numsamples);
	void Process (float *pdest, float *psrc, int numsamples);

	void Process (float *psamples,           int numsamples, float p_Detune);
	void Process (float *pdest, float *psrc, int numsamples, float p_Detune);
};

#endif
